/* ============ */
/* cupndefs.h	*/
/* ============ */
/* ==================================================================== */
/*     TYPEDEFS, #DEFINES AND PROTOTYPES FOR COUPON COLLECTOR'S TEST	*/
/* ==================================================================== */
# if defined(__CUPNDEFS_H__)
#	/* Do Nothing */
# else
#	define	__CUPNDEFS_H__

# if !defined(__DEFCODES)

typedef	unsigned char		UCHAR;
typedef	unsigned int		UINT;

#define	FALSE	0
#define	TRUE	1
# endif

#define MAX_CELL_XPCT	   100
#define MIN_CELL_XPCT	     5
#define	MAX_COUPON_LEN	   100
#define	MAX_SET_SIZE	    25
#define	MIN_SET_SIZE	     5
#define	MAX_NUM_COUPONS	   32767
#define	MIN_NUM_COUPONS	   400

/* ------------------- */
/* FUNCTION PROTOTYPES */
/* ------------------- */
# undef F
# if defined(__STDC__) || defined(__PROTO__)
#	define  F( P )  P
# else
#	define  F( P )  ()
# endif

/* INDENT OFF */
typedef	struct	CouponDataStru
    {
	int	SetSize;	/* Number Unique Integers in One Coupon */
	int	NumCoupons;	/* Number of Coupons to be Collected	*/
	int	UserCellExpect;	/* User-Minimum Cell Expectation	*/
	int	MaxCpnLen;	/* Maximum Length of Tallied Segments	*/
	int	NumCategories;	/* No. Categories to Receive Tallies	*/
	long	TotNumGen;	/* Number Variates Generated This Run	*/
	long	UserNumCoupons;	/* No. Coupons to meet UserCellExpect	*/
	long	IdealNumCoupons;/* No. Coupons to meet MIN_CELL_XPCT	*/
	long	MaxGenPerSeg;	/* FAILURE Criteria for Generator	*/
	long	ActMaxPerSeg;	/* Actual Maximum Generated for Segemnt	*/
	int	CallStatusOK;	/* 0 = FALSE, 1 = TRUE			*/
	int	NotEnough;	/* # Categories < UserCellExpect	*/
	double	*CellExpect;	/* Calculated Cell Expectations 	*/
	double	CouponChiSq;	/* Coupon-Run Chi-Square Data		*/
	int	(*RandFun) F((void));/* Addr. of Generating Function	*/
    }
	COUPON_DATA_STRU;

extern	void	CalcCouponProbs F((int, int, double *));
extern	void	CalcMeanStdDev F((UINT, double *, double *));
extern	void	CalcCouponChiSq F((struct CouponDataStru *));
extern	UINT	GenCouponData F((struct CouponDataStru *));
extern	void	SetCouponControls F((struct CouponDataStru *));

# undef F
/* INDENT ON */

# endif				/* <<< __CUPNDEFS_H__ >>> */
